<?php defined('PF_VERSION') OR exit('Access denied');?>
<?php

define('PLUGIN_CONFIGURATION', __('Configuration','configuration'));

class Configuration_Plugin extends Pf_Plugin{
    public $name = PLUGIN_CONFIGURATION;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is Configuration system';

    public function admin_init(){
        if(is_admin()){
            $this->admin_menu ( 'fa fa-wrench', __('Configuration','configuration'), 'configuration', 'setting_manager_main');
            $this->admin_children_menu ( 'fa fa-angle-double-right', __('Settings','configuration'), 'settings', 'setting_manager_main', 'Configuration' );
            $this->admin_children_menu ( 'fa fa-angle-double-right', __('Email templates','configuration'), 'email-templates', 'email_template_manager_main', 'Configuration' );
            $this->admin_children_menu ( 'fa fa-angle-double-right', __('Backup','configuration'), 'backup', 'backup_restore', 'Configuration' );
        }
    }
    
    public function setting_manager_main() {
        $this->css ( 'admin/themes/default/assets/bootstrap-notification/css/animate.min.css' );
        $this->css ( 'configuration/css/style.css',__FILE__ );
        $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js' );
        $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
        $this->js ( 'admin/themes/default/assets/js/jquery.serializeObject.js' );

        require abs_plugin_path(__FILE__) . '/configuration/settings/settings.php';
    }
    public function email_template_manager_main() {
        $this->css ( 'configuration/css/style.css',__FILE__ );
        $this->css ( 'admin/themes/default/assets/bootstrap-notification/css/animate.min.css' );
        $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js' );
        $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
        
        require abs_plugin_path(__FILE__) . '/configuration/email-templates/email-templates.php';
    }
    
    public function backup_restore(){
        $this->css ( 'admin/themes/default/assets/bootstrap-modal/css/animate.min.css' );
        $this->js ( 'admin/themes/default/assets/bootstrap-modal/js/jquery/jquery.easing.1.3.js' );
        $this->js ( 'admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js' );
        $this->js ( 'configuration/backup/ajax/ajax.js',__FILE__ );
        
        require_once abs_plugin_path(__FILE__) . "/configuration/backup/pclzip.lib.php";
        require_once abs_plugin_path(__FILE__) . "/configuration/backup/backup-class.php";
        require_once abs_plugin_path(__FILE__) . "/configuration/backup/action/main.php";
    }
}
